import java.io.Reader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;

class P2 {

  public static void
  main(String args[]) throws java.io.IOException {

	if (args.length != 1) {
		System.out.println(
			"Error: Input file must be named on command line." );
		System.exit(-1);
	}

	Reader yyin = null;

	try {
		yyin = new BufferedReader(new FileReader(args[0]));
	} catch (FileNotFoundException notFound){
		System.out.println ("Error: unable to open input file.");
		System.exit(-1);
	}

    // lex is a JLex-generated scanner that reads from yyin
	final Yylex lex = new Yylex(yyin);	

	System.out.println ("Begin test of CSX scanner.");

	/**********************************************
	
	You should enter code here that thoroughly tests your scanner.

	Be sure to test extreme cases, like very long symbols or lines,
	invalid tokens, unrepresentable integers, and invalid strings.
	
	The following is only a starting point.
	**********************************************/


	Symbol token = lex.yylex();

	while ( token.sym != sym.EOF) {

		System.out.print( token.value.linenum + ":"
				+ token.value.colnum + "\t");

		switch (token.sym) {
		case sym.INTLIT:
			System.out.println("integer literal(" +
				((CSXIntLitToken) token.value).intValue + ")");
			break;

		case sym.PLUS:
			System.out.println("Symbol (" + "+" + ")");
			break;

		case sym.MINUS:
			System.out.println("Symbol (" + "-" + ")");
			break;

		default:
			System.out.println("unrecognized token type: " + token.value);
		} // switch(token.sym)
		token = lex.yylex(); // get next token
	} // not at EOF
	System.out.println("End test of CSX scanner.");
  } // main()

} // class P2
